/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.renderdoc;

import com.nyfaria.numismaticoverhaul.owostuff.ops.TextOps;
import com.nyfaria.numismaticoverhaul.owostuff.renderdoc.RenderDoc;
import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseOwoScreen;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.ButtonComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.CheckboxComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.Components;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.LabelComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.Containers;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.FlowLayout;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Color;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.HorizontalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.OwoUIAdapter;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Surface;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.VerticalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.CommandOpenedScreen;
import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderdocScreen
extends BaseOwoScreen<FlowLayout>
implements CommandOpenedScreen {
    private int ticks = 0;
    private boolean setCaptureKey = false;
    @Nullable
    private RenderDoc.Key scheduledKey = null;
    private ButtonComponent captureKeyButton = null;
    private LabelComponent captureLabel = null;

    @Override
    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create(this, Containers::verticalFlow);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT);
        EnumSet<RenderDoc.OverlayOption> overlayState = RenderDoc.getOverlayOptions();
        this.captureKeyButton = Components.button(Component.m_130674_((String)"Capture Hotkey"), button -> {
            button.f_93623_ = false;
            button.m_93666_(Component.m_130674_((String)"Press..."));
            this.setCaptureKey = true;
        });
        this.captureLabel = Components.label(this.createCapturesText());
        rootComponent.child(Containers.verticalFlow(Sizing.content(), Sizing.content()).child(Components.label((Component)Component.m_237113_((String)"RenderDoc Controls")).shadow(true).margins(Insets.top(5).withBottom(10))).child(Containers.grid(Sizing.content(), Sizing.content(), 2, 2).child(RenderdocScreen.overlayControl(Component.m_130674_((String)"Enabled"), overlayState, RenderDoc.OverlayOption.ENABLED), 0, 0).child(RenderdocScreen.overlayControl(Component.m_130674_((String)"Capture List"), overlayState, RenderDoc.OverlayOption.CAPTURE_LIST), 0, 1).child(RenderdocScreen.overlayControl(Component.m_130674_((String)"Frame Rate"), overlayState, RenderDoc.OverlayOption.FRAME_RATE), 1, 0).child(RenderdocScreen.overlayControl(Component.m_130674_((String)"Frame Number"), overlayState, RenderDoc.OverlayOption.FRAME_NUMBER), 1, 1)).child(Components.box(Sizing.fixed(175), Sizing.fixed(1)).color(Color.ofFormatting(ChatFormatting.DARK_GRAY)).fill(true).margins(Insets.vertical(5))).child(Containers.grid(Sizing.content(), Sizing.content(), 2, 2).child(Components.button(Component.m_130674_((String)"Launch UI"), button -> RenderDoc.launchReplayUI(true)).horizontalSizing(Sizing.fixed(90)).margins(Insets.of(2)), 0, 0).child(this.captureKeyButton.horizontalSizing(Sizing.fixed(90)).margins(Insets.of(2)), 1, 0).child(Components.button(Component.m_130674_((String)"Capture Frame"), button -> RenderDoc.triggerCapture()).horizontalSizing(Sizing.fixed(90)).margins(Insets.of(2)), 0, 1).child(this.captureLabel, 1, 1).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER)).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of(5)).surface(Surface.flat(0x77000000).and(Surface.outline(0x77000000)))).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER);
    }

    public void m_86600_() {
        super.m_86600_();
        if (++this.ticks % 10 != 0) {
            return;
        }
        if (this.scheduledKey != null) {
            RenderDoc.setCaptureKeys(this.scheduledKey);
            this.scheduledKey = null;
        }
        this.captureLabel.text(this.createCapturesText());
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.setCaptureKey) {
            this.captureKeyButton.f_93623_ = true;
            this.captureKeyButton.m_93666_(Component.m_130674_((String)"Capture Hotkey"));
            this.setCaptureKey = false;
            RenderDoc.Key key = RenderDoc.Key.fromGLFW(keyCode);
            if (key != null) {
                this.ticks = 0;
                this.scheduledKey = key;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private Component createCapturesText() {
        return TextOps.withColor("Captures: \u00a7" + RenderDoc.getNumCaptures(), TextOps.color(ChatFormatting.WHITE), 55295);
    }

    private static CheckboxComponent overlayControl(Component name, EnumSet<RenderDoc.OverlayOption> state, RenderDoc.OverlayOption option) {
        CheckboxComponent checkbox = Components.checkbox(name);
        checkbox.margins(Insets.of(3)).horizontalSizing(Sizing.fixed(100));
        checkbox.checked(state.contains((Object)option));
        checkbox.onChanged(enabled -> {
            if (enabled.booleanValue()) {
                RenderDoc.enableOverlayOptions(option);
            } else {
                RenderDoc.disableOverlayOptions(option);
            }
        });
        return checkbox;
    }
}

